// 8PKPool.h:
//  

#ifndef __8PKPOOL_H__
#define __8PKPOOL_H__


#include	"8MemPool.h"

#include	"misc.h"


class C8PKPool
{
public:
// Construction
	C8PKPool();

	BOOL Create( char *lpszFileName = NULL );

// Operations
	BOOL AllocAcptPacket( LPOVERLAPPEDPLUS &newolp );
	BOOL AllocRecvPacket( LPOVERLAPPEDPLUS &newolp );
	BOOL AllocSendPacket( LPOVERLAPPEDPLUS &newolp );

	BOOL FreeAcptPacket( LPOVERLAPPEDPLUS olp );
	BOOL FreeRecvPacket( LPOVERLAPPEDPLUS olp );
	BOOL FreeSendPacket( LPOVERLAPPEDPLUS olp );

// Implementation
protected:
	FILE*				m_hLogFile;

	BOOL				LogOpen( char *lpszFileName );
	BOOL	__cdecl		LogWrite( char *lpszFmt, ... );
	void				LogClose();

	C8MemPool <OVERLAPPEDPLUS> * m_pAcptPool;
	C8MemPool <OVERLAPPEDPLUS> * m_pRecvPool;
	C8MemPool <OVERLAPPEDPLUS> * m_pSendPool;

public:
	~C8PKPool();
};


#endif // __8PKPOOL_H__

